<?php
// confirm_otp.php - enter OTP and confirm
session_start();
require_once __DIR__ . '/IPPAuth.php';
$api = new IPPAuth();

if (empty($_SESSION['tmp_token'])) {
    header('Location: login.php'); exit;
}

$message = '';
$lastSend = $_SESSION['last_send_resp'] ?? null;
$secondsRemaining = null;
if ($lastSend && isset($lastSend['seconds_remaining'])) $secondsRemaining = intval($lastSend['seconds_remaining']);

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action'])) {
    if ($_POST['action'] === 'confirm') {
        $otp = trim($_POST['otp'] ?? '');
        if ($otp === '') { $message = 'کد OTP را وارد کنید.'; }
        else {
            $res = $api->confirmOtp($_SESSION['tmp_token'], $otp);
            $_SESSION['last_confirm'] = $res;
            if (!empty($res['meta']['status']) && $res['meta']['status'] === true) {
                $_SESSION['final_token'] = $res['data']['token'] ?? '';
                unset($_SESSION['tmp_token']);
                header('Location: dashboard.php'); exit;
            } else {
                $message = $res['meta']['message'] ?? 'کد نامعتبر است.';
            }
        }
    } elseif ($_POST['action'] === 'resend') {
        $resp = $api->sendSmsOtp($_SESSION['tmp_token']);
        $_SESSION['last_send_resp'] = $resp;
        // if success, token may update
        if (!empty($resp['meta']['status']) && $resp['meta']['status'] === true) {
            $_SESSION['tmp_token'] = $resp['data']['token'] ?? $_SESSION['tmp_token'];
        }
        // stay on page to display message
        header('Location: confirm_otp.php'); exit;
    }
}
?><!doctype html><html lang="fa" dir="rtl"><head><meta charset="utf-8"><title>تأیید OTP</title>
<meta name="viewport" content="width=device-width,initial-scale=1">
<style>
:root{--bg:#f6f8fb;--card:#fff;--accent:#0ea5a4;--muted:#64748b}
*{box-sizing:border-box;font-family:Tahoma, sans-serif}
body{background:var(--bg);margin:0;padding:20px;direction:rtl}
.container{max-width:720px;margin:40px auto}
.card{background:var(--card);padding:22px;border-radius:10px;box-shadow:0 8px 30px rgba(11,18,32,0.06)}
input{width:100%;padding:10px;margin-bottom:12px;border:1px solid #e2e8f0;border-radius:8px}
button{padding:10px 14px;border-radius:8px;border:none;background:var(--accent);color:#022;font-weight:600;cursor:pointer}
.small{background:#fff;border:1px solid #e2e8f0;padding:8px;border-radius:6px}
.msg{color:#c00;margin-bottom:12px}
.info{background:#f3f7f7;padding:10px;border-radius:6px;border:1px solid #e6efef;color:#333}
</style>
</head><body><div class="container"><div class="card">
<h3>وارد کردن کد یک‌بار مصرف (OTP)</h3>
<?php if($message): ?><div class="msg"><?=htmlspecialchars($message)?></div><?php endif; ?>
<?php if($lastSend && !empty($lastSend['meta']['status']) && $lastSend['meta']['status']===false): ?>
    <div class="info">پیام سرور: <?=htmlspecialchars($lastSend['meta']['message'] ?? '')?><?php if($secondsRemaining): ?> — <?= $secondsRemaining ?> ثانیه تا ارسال مجدد <?php endif; ?></div>
<?php endif; ?>
<form method="post"><input name="otp" placeholder="کد پیامک را وارد کنید"><div style="display:flex;gap:8px;margin-top:6px"><button name="action" value="confirm" type="submit">تأیید</button>
<button name="action" value="resend" type="submit" style="background:#fff;border:1px solid #e2e8f0;color:#111">ارسال مجدد</button></div></form>
<?php if(isset($_SESSION['last_confirm'])): ?><details style="margin-top:12px"><summary>لاگ پاسخ تأیید (برای دیباگ)</summary><pre style="background:#efefef;padding:8px;border-radius:6px"><?=htmlspecialchars(json_encode($_SESSION['last_confirm'], JSON_UNESCAPED_UNICODE|JSON_PRETTY_PRINT))?></pre></details><?php endif; ?>
</div></div></body></html>